// $Id: CCountedObject.cpp,v 1.5 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CCountedObject.hpp"
using Exponent::Basics::CCountedObject;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION_NO_PARENT(CCountedObject);

//	===========================================================================
CCountedObject::CCountedObject() : m_referenceCount(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CCountedObject);
	// If you store it you should call referenced
	m_referenceCount = 0;
}

//	===========================================================================
CCountedObject::CCountedObject(const char *className) : m_referenceCount(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CCountedObject);
	// If you store it you should call referenced
	m_referenceCount = 0;
}

//	===========================================================================
CCountedObject::~CCountedObject()
{
	EXPONENT_CLASS_DESTRUCTION(CCountedObject);
	// Nothing to do here...
}

//	===========================================================================
void CCountedObject::referenced()  
{ 
	m_referenceCount++; 
}

//	===========================================================================
void CCountedObject::dereference()
{
	m_referenceCount--;
	if (m_referenceCount <= 0)
	{
		delete this;
	}
}

//	===========================================================================
long CCountedObject::getReferenceCount() const 
{ 
	return m_referenceCount; 
}

//	===========================================================================
void CCountedObject::getObjectDescription(char *string, const long size) const
{
	// Create the two strings
	char buffer[1024] = "[CCounted Object Base Reference Count = ";
	char buffer2[10];
	sprintf(buffer2, "%li", m_referenceCount);

	// Merge them
	strcat(buffer, buffer2);

	// Now copy to string
	strncpy(string, buffer, size * sizeof(char));
}
